#!/bin/sh

MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG=""
MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_OK=0
MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR=1

MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE=${MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR}
MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0


master_page_new_esxi_info_conf() {
    debug_print "${0}" "${LINENO}" 'in function "master_page_new_esxi_info_conf"'    
    
    tp_ip_divider_username_password \
        "${MASTER_PAGE_NEW_ESXI_INFO_CONF_TITLE}" \
        "${MASTER_PAGE_NEW_ESXI_INFO_CONF_TEXT}" \
        "${MASTER_PAGE_NEW_ESXI_INFO_CONF_LABEL_OK}" \
        "${MASTER_PAGE_NEW_ESXI_INFO_CONF_LABEL_CANCEL}" \
        "${new_esxi_host_ip:-""}" \
        "${new_esxi_username:-""}" \
        "${new_esxi_password:-""}"
        
        
    debug_print "${0}" "${LINENO}" "TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE: ${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE}"
    case "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CODE}" in
    
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_ERROR}")
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_MSG}"
            return
            ;;
        
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_CANCEL}")
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_OK
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=-1
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG=""
            return
            ;;
            
        "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_OK}" )
            ;;
        
        *)
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
            MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_INFO_CONF_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    debug_print "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP}:${RT_ESXI_IP:-${conf_esxi_ip}}"
    if [ "${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP}" == "${RT_ESXI_IP:-$conf_esxi_ip}" ]; then
        debug_print "the given esxi server is already existing: $TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP"
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_INFO_CONF_CLUSTER_ALREADY_EXIST_ERROR}: $TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP"
        return
    fi
    
    # defined from master_page_add_esxi.sh
    new_esxi_host_ip="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_IP}"
    new_esxi_username="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_USERNAME}"
    new_esxi_password="${TP_IP_DIVIDER_USERNAME_PASSWORD_RESULT_PASSWORD}"
    
    # precondition check
    local msg
    local ret
    msg=`dtascfg "${DTASCFG_XML_FILE}" get management_server ip`
    ret="${?}"
    debug_print "ret='${ret}', msg='${msg}'"
    
    if [ "${ret}" -eq 0 -a \( "${new_esxi_host_ip}" == "${msg}" -o "${new_esxi_host_ip}" == "127.0.0.1" \) ]; then
        debug_print "User adding it self as slave, and the ip is '${new_esxi_host_ip}'"

        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE="${MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR}"
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_MS_IMAGE_PATH_SELECT_INVALID_SLAVE_STATUS}"
        return
    
    elif [ "${ret}" -ne 0 ]; then
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE="${MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR}"
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG="${msg}"
        return
    fi
    
    
    # check esxi connection
    utility_get_esxi_datastore_mapping \
        "${new_esxi_host_ip}" \
        "${new_esxi_username}" \
        "${new_esxi_password}"
    ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        debug_print "TerminateByCtrlC: ret='${ret}'"
        
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE="${MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_OK}"
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG=""
        return
    
    elif [ "${ret}" -ne 0 ]; then
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE="${MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR}"
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG="${ERROR_ESXI_WRONG_USERNAME_PASSWORD}"
        return
    fi
    
    `php $CONS_BACKEND is_cluster_existing "${new_esxi_host_ip}"`
    if [ "${?}" -eq 0 ]; then
        debug_print "the given esxi server is already existing: $new_esxi_host_ip"
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ERROR
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=0
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_MSG="${MASTER_PAGE_NEW_ESXI_INFO_CONF_CLUSTER_ALREADY_EXIST_ERROR}: $new_esxi_host_ip"
    else
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_CODE=$MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_OK
        MASTER_PAGE_NEW_ESXI_INFO_CONF_RESULT_ROLLING=1
    fi     

}